/*
 * Decompiled with CFR 0.152.
 */
package emulator.unittest.hardware.memory;

import emulator.EmulatorException;
import emulator.hardware.debug.BusWatchException;
import emulator.hardware.memory.DebugMemoryBlock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DebugMemoryReadWatchTest {
    private DebugMemoryBlock memory;

    @Before
    public void setUp() throws Exception {
        this.memory = new DebugMemoryBlock(4096);
        this.memory.enableReadWatch(512, 767, true);
    }

    @Test(expected=BusWatchException.class)
    public void testReadWatchInside() throws EmulatorException {
        this.memory.read(512);
    }

    @Test
    public void testReadWatchOutside() throws EmulatorException {
        Assert.assertEquals((long)0L, (long)this.memory.read(768));
    }

    @Test
    public void testReadWatchIgnoresWrite() throws EmulatorException {
        this.memory.write(512, 170);
    }
}

